CREATE OR REPLACE FUNCTION ab2__a_d__resource_requirement__delete()
  RETURNS TRIGGER AS $$

  DECLARE

      _prefix varchar := 'TRIGGER ab2__a_d__resource_requirement__delete -';
      _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

  BEGIN

      -- Debug
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% a2_id:%;', _prefix, old.a2_id;
      END IF;

      -- AG-Ressource löschen.
      DELETE FROM scheduling.resource
            WHERE context_id = old.a2_id
              AND context = 'ab2';

      RETURN old;

  END $$ LANGUAGE plpgsql;
--
DROP TRIGGER IF EXISTS ab2__a_d__resource_requirement__delete ON public.ab2;
CREATE TRIGGER ab2__a_d__resource_requirement__delete
  AFTER DELETE ON ab2
  FOR EACH ROW
  EXECUTE PROCEDURE ab2__a_d__resource_requirement__delete();
